<?php

/**
 * @version     1.0.0
 * @package     com_portfolio
 * @copyright   Bản quyền (C) 2015. Các quyền đều được bảo vệ.
 * @license     bản quyền mã nguồn mở GNU phiên bản 2
 * @author      Truong <nguyenbatruong0202@gmail.com> - http://joomlavi.com
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Portfolio helper.
 */
class PortfolioHelper {

    /**
     * Configure the Linkbar.
     */
    public static function addSubmenu($vName = '') {
        		JHtmlSidebar::addEntry(
			JText::_('COM_PORTFOLIO_TITLE_CATEGORYS'),
			'index.php?option=com_portfolio&view=categorys',
			$vName == 'categorys'
		);
		JHtmlSidebar::addEntry(
			JText::_('COM_PORTFOLIO_TITLE_TESTS'),
			'index.php?option=com_portfolio&view=tests',
			$vName == 'tests'
		);

    }

    /**
     * Gets a list of the actions that can be performed.
     *
     * @return	JObject
     * @since	1.6
     */
    public static function getActions() {
        $user = JFactory::getUser();
        $result = new JObject;

        $assetName = 'com_portfolio';

        $actions = array(
            'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
        );

        foreach ($actions as $action) {
            $result->set($action, $user->authorise($action, $assetName));
        }

        return $result;
    }


}
